<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Stock extends Model 
{

    protected $table = 'stocks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('branch_id', 'cost', 'receive_no', 'location', 'status');
    protected $visible = array('branch_id', 'cost', 'receive_no', 'location', 'status');

    public function products()
    {
        return $this->belongsTo('Product', 'product_id');
    }

    public function suppliers()
    {
        return $this->belongsTo('Supplier', 'supplier_id');
    }

    public function branchs()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

}